<!DOCTYPE html>
<html>
<head>
    <title>Live Chat</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="https://js.pusher.com/7.0/pusher.min.js" integrity="sha384-Your-Integrity-Here" crossorigin="anonymous"></script>
</head>
<body>
    <div id="chat-container">
        <ul id="messages"></ul>
        <input type="text" id="message-input" placeholder="Type a message...">
        <button onclick="sendMessage()">Send</button>
    </div>

    <script>
        console.log('jQuery loaded:', typeof jQuery !== 'undefined');
        console.log('Pusher loaded:', typeof Pusher !== 'undefined');

        var senderId = {{ isset($senderId) ? $senderId : 29 }};
        var receiverId = {{ isset($receiverId) ? $receiverId : 28 }};

        // Load chat history on page load
        $.ajax({
            url: '/messages',
            method: 'GET',
            data: {
                sender_id: senderId,
                receiver_id: receiverId
            },
            success: function(response) {
                if (response.status === 'success') {
                    response.data.forEach(function(msg) {
                        var from = msg.Sender_id == senderId ? 'You' : (msg.sender ? msg.sender.Email : 'Unknown');
                        $('#messages').append('<li>' + from + ': ' + msg.Content + ' (' + msg.Sent_at + ')</li>');
                    });
                }
            },
            error: function(xhr, status, error) {
                console.error('Error loading messages:', error);
            }
        });

        window.sendMessage = function() {
            console.log('sendMessage executed');
            var content = $('#message-input').val();
            if (!content) {
                alert('Please enter a message');
                return;
            }

            $.ajax({
                url: '/messages',
                method: 'POST',
                data: {
                    Sender_id: senderId,
                    Receiver_id: receiverId,
                    Content: content,
                    Is_read: false,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.status === 'success') {
                        $('#message-input').val('');
                        $('#messages').append('<li>You: ' + content + ' (' + new Date().toLocaleTimeString() + ')</li>');
                        console.log('Message sent:', response);
                    } else {
                        alert('Server error: ' + JSON.stringify(response.errors));
                    }
                },
                error: function(xhr, status, error) {
                    alert('Error sending message: ' + (xhr.responseJSON?.message || error));
                    console.error('Error details:', xhr.responseText);
                }
            });
        };

        if (typeof Pusher !== 'undefined') {
            Pusher.logToConsole = true;
            var pusher = new Pusher('{{ env('PUSHER_APP_KEY') }}', {
                cluster: '{{ env('PUSHER_APP_CLUSTER') }}',
                forceTLS: true,
                authEndpoint: '/broadcasting/auth',
                auth: {
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                }
            });

            var channel = pusher.subscribe('private-chat.' + senderId);
            channel.bind('App\\Events\\NewMessage', function(data) {
                if (data.message) {
                    var from = data.message.Sender_id == senderId ? 'You' : (data.user ? data.user.Email : 'Unknown');
                    $('#messages').append('<li>' + from + ': ' + data.message.Content + ' (' + data.message.Sent_at + ')</li>');
                }
            });
        } else {
            console.error('Pusher not loaded');
        }
    </script>
</body>
</html>
